# -*- coding: utf-8 -*-
"""
Solves the transportation problem of the Styrian Montan Society.

@author: ladner
"""

import pulp
import pandas as pd

df = pd.read_csv("transportation_costs.csv", sep=";", index_col=0)
costs = df.to_dict(orient="index")
erzlager = df.index.tolist()
hochofen = df.columns.tolist()

df = pd.read_csv("transportation_vectors.csv", sep=";")
supply = {erzlager[i] : df.supply[i] for i in range(len(erzlager))}
demand = {hochofen[j] : df.demand[j] for j in range(len(hochofen))}

##data
#erzlager = ["E1", "E2", "E3"]
#supply = {"E1": 1500,
#        "E2": 2000,
#        "E3": 1000}
#        
#hochofen = ["H1", "H2"]
#demand = {"H1": 2000, "H2": 2500}

#        H1, H2
#cost_lists = [[110, 80], #E1
#        [90,90],    #E2
#        [140,160]] #E3
#        
#costs = {}
#for idx, row in enumerate(cost_lists):
#    inner_dict =  {}
#    for idx_inner, column in enumerate(row):
#        inner_dict[hochofen[idx_inner]] = column
#    costs[erzlager[idx]] = inner_dict
#
#costs = {"E1": {"H1": 110, "H2":80},
#         "E2": {"H1": 90, "H2":90},
#         "E3": {"H1": 140, "H2":160}}

#pulp
tpp = pulp.LpProblem("The transportation problem",pulp.LpMinimize) #problem

x = pulp.LpVariable.dicts("x", (erzlager, hochofen), 0, None, pulp.LpInteger) #variables

tpp += pulp.lpSum([costs[i][j] * x[i][j] for i in erzlager for j in hochofen]), "objective function"

for i in erzlager:
    tpp += pulp.lpSum([x[i][j] for j in hochofen]) <= supply[i], "erzlager capacity constraints {}".format(i)

for j in hochofen:
    tpp += pulp.lpSum([x[i][j] for i in erzlager]) >= demand[j], "hochofen capacity constraints {}".format(j)

tpp.writeLP("transportation.lp") #write LP file

tpp.solve() #call the solver

print("Status:", pulp.LpStatus[tpp.status]) #print status

for var in tpp.variables(): #print variables
    print(var.name,"=", var.varValue)

print("objective value:", pulp.value(tpp.objective)) #print objective value


