# -*- coding: utf-8 -*-
"""
Solves the rucksack ILP.

@author: ladner
"""

import pulp

#data
profits = [10,6,3,8,1]
weights = [10,6,4,9,3]
c = 19

#pulp
rucksack_ilp = pulp.LpProblem("The rucksack ILP", pulp.LpMaximize) #problem

x = pulp.LpVariable.dicts("x", [x+1 for x in range(5)], 0, 1, pulp.LpInteger) #variables

rucksack_ilp += pulp.lpSum([profits[j-1] * x[j] for j in x]), "objective function"

rucksack_ilp += pulp.lpSum([weights[j-1] * x[j] for j in x]) <= c, "capacity constraints"

rucksack_ilp.writeLP("rucksack_ilp.lp") #write LP file

rucksack_ilp.solve() #call the solver

print("Status:", pulp.LpStatus[rucksack_ilp.status]) #print status

for var in rucksack_ilp.variables(): #print variables
    print(var.name,"=", var.varValue)

print("objective value:", pulp.value(rucksack_ilp.objective)) #print objective value


