# -*- coding: utf-8 -*-
"""
Solves a simple lp problem.

@author: ladner
"""

import pulp

lp_simple = pulp.LpProblem("A simple lp problem",pulp.LpMaximize)

x1 = pulp.LpVariable("x_1", 0)
x2 = pulp.LpVariable("x_2", 0)
x3 = pulp.LpVariable("x_3")

lp_simple += 3*x1 + x2 + x3, "objective function"

lp_simple += 3*x1 + 2*x2 + 2*x3 <= 10, "first constraint"
lp_simple += -x1 + 3*x2 -x3 <= 13, "second constraint"
lp_simple += -x2 -x3 <= 7, "third constraint"
lp_simple += 2*x1 + x3 == 2, "equation"

lp_simple.writeLP("lp_simple.lp")

lp_simple.solve()

print("Status:", pulp.LpStatus[lp_simple.status])

for var in lp_simple.variables():
    print(var.name,"=", var.varValue)

print("objective value:", pulp.value(lp_simple.objective))


